/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	MakeColinear.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CConstraints.h"
#include "CApplication.h"


HRESULT MakeColinear(ISet *objSet)
{

	//	Applies the Colinear constraint on the set of given lines

	START_METHOD("MakeColinear")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	// Create another object set
	ISet *objectSet2 = NULL;

	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&objectSet2);
	CHECK_RETURN_STATUS(status)

	// Get any member of the objSet
	IDispatch *object = NULL;
	status = objSet->GetAnyMember(&object);
	CHECK_RETURN_STATUS(status)

	// Get the parent workplane of the object
	IObject *parentWorkplane = NULL;
	status = CAST(IObject,object)->GetParent(GetBSTR("Workplane"), &parentWorkplane);
	CHECK_RETURN_STATUS(status)

	// Get the first object of objSet
	IIt *pObjectIt = NULL;
	status = (GetCLASS(It))->CreateAObjectIt(objSet, &pObjectIt);
	CHECK_RETURN_STATUS(status)

	IDispatch *pDispObject = NULL;
	status = pObjectIt->start(&pDispObject);
	CHECK_RETURN_STATUS(status)

	// Add the object to objectset2
	status = objectSet2->AddMember(pDispObject);
	CHECK_RETURN_STATUS(status)

	long noOfObjects1 = 0;
	long noOfObjects2 = 0;

	long index1 = 0;
	long index2 = 0;

	//Get the number of objects in objSet ( to iterate through the set )
	status = objSet->GetCount(&noOfObjects1);
	CHECK_RETURN_STATUS(status)

	IDispatch *line1 = NULL;
	pObjectIt->Next(&line1);
	while (line1) {

		//Get the number of objects in objSet ( to iterate through the set )
		status = objectSet2->GetCount(&noOfObjects2);
		CHECK_RETURN_STATUS(status)

		IIt *pObjectIt2 = NULL;
		status = (GetCLASS(It))->CreateAObjectIt(objectSet2,&pObjectIt2);
		CHECK_RETURN_STATUS(status)

		IDispatch *line2 = NULL;
		pObjectIt2->start(&line2);
		while (line2) {

			// Get the index2-th object of objectSet2
			IColinear *pColinear = NULL;
			status = (GetCLASS(Colinear))->CreateColinear(CAST(ILine, line1), CAST(ILine, line2), &pColinear);
			CHECK_RETURN_STATUS(status)

			IConstraint *pConstraint1 = NULL;

			status = CAST(IWorkplane, parentWorkplane)->GetConstraint(CAST(IGeomConstraint, pColinear), &pConstraint1);
			CHECK_RETURN_STATUS(status)

			if(pConstraint1) {
					pColinear->Release();
			}
			else {
					IConstraint *pConstraint2 = NULL;

					status = activeWorkplane->CreateConstraint(CAST(IGeomConstraint, pColinear), &pConstraint2);
					CHECK_RETURN_STATUS(status)
			}

		line2 = NULL;
		pObjectIt2->Next(&line2);
		}

		// Add the object to objectset2
		status = objectSet2->AddMember(line1);
		CHECK_RETURN_STATUS(status)

	line1 = NULL;
	pObjectIt->Next(&line1);
	}

	END_METHOD("MakeColinear")
}
